# DEMONATA GAMING MOD METADATA LICENSE v1.0

Last Updated: 2025-08-02

This license applies to the **original metadata structures, documentation formats, and organizational logic** created by **Demonata Gaming** for use in XML-based game modding projects, including (but not limited to) those developed for _7 Days to Die_.

---

## 🎯 PROTECTED CONTENT

The following components are **protected under this license** and may **not** be reused, modified, or redistributed—publicly or privately—**without clear attribution**:

- Structured metadata blocks and top-of-file headers:
  `@version`, `@date`, `@group`, `@description`, `@xref`, `@notes`
- Comment-based section headers and formatting syntax:
  `<!-- ==================== SECTION: EXAMPLE ==================== -->`
- In-line documentation style, explanation language, and formatting
- Cross-referencing conventions between files:
  `@xref file.xml → Section Name`
- Naming systems for patch sections, mod groups, or internal IDs
- Logical file structure and organizational methodology (e.g. by biome, difficulty, time-of-day, etc.)

These elements are **original to Demonata Gaming** and are **not part of the vanilla XML schema** provided by the game developer or general modding APIs.

---

## ✅ WHAT YOU **CAN** USE

You are free to:

- Use standard XML syntax and modding structures
- Reference vanilla game data (entity names, values, loot tables, etc.)
- Apply similar logic or functions (e.g., modifying recipes, spawn rates)
- Develop your own documentation or metadata systems
- Learn from this mod’s structure for private use or experimentation

This license **does not** restrict your ability to:

- Create similar mods from scratch
- Build on public modding knowledge
- Share similar ideas in new and original formats

Just don’t copy the _how_ unless you credit the _who_.

---

## 📌 ATTRIBUTION REQUIREMENTS

Want to reuse the metadata style, organization, or documentation format? No problem—just credit it.

**Required attribution format:**

> "Based in part on structural documentation by Demonata Gaming."

You can include this:

- In your README
- In top-of-file comments
- On your mod’s description page

If you’re unsure whether your use qualifies—**ask first**. It’s easier than apologizing later.

---

## ❌ NOT PERMITTED WITHOUT PERMISSION

The following actions **require explicit written permission** from Demonata Gaming:

- Reposting or distributing any file structure, documentation format, or comment style based on this system without attribution
- Using this metadata system as the basis for another public-facing mod without credit
- Removing or stripping documentation and re-releasing with minor edits
- Using any part of this structure for **commercial or paid content**

---

## ⚖️ LEGAL DECLARATION

This license is a formal declaration of **authorship and intellectual property** under U.S. and international copyright law.

It does **not** claim ownership of the game engine, vanilla assets, or XML syntax.

However, it **does** protect the **unique expression** of:

- Metadata formatting
- Documentation structure
- Section organization
- Commentary and explanation style

All rights reserved where applicable.
This license operates independently of the licensing terms of _7 Days to Die_ or any third-party modding frameworks.
This license acknowledges the EULA of 7 Days to Die but does not grant any additional rights to The Fun Pimps beyond what that EULA defines.

---

## 💬 PERSONAL USE POLICY

You may:

- Use this system as learning material
- Copy it into private projects
- Modify it for personal, non-distributed use

But if you’re publishing a mod and borrowing the structure, **credit it.** It’s just respectful.

---

## 📬 CONTACT

For questions, collaboration, or permission requests, reach out to:

**Demonata Gaming**
YouTube: [Insert Link]
Mod.io / NexusMods Profile: [Insert Link]

---

## 🛡️ FINAL WORD

If you found this structure useful, **credit the creator**.
If you're inspired, that’s great—**just don’t plagiarize**.

---

## 🔖 TL;DR

- You **can’t** copy this structure without credit.
- You **can** use standard XML and mod logic.
- You **must** credit if you reuse this formatting or metadata system.
- When in doubt? **Ask first.** No drama necessary.

---

### 📄 NOTE ON TFP LICENSE AGREEMENT

By using the 7 Days to Die software, I acknowledge that The Fun Pimps reserve the right to use or adapt user-created content—including metadata formats and file structures—within their own software ecosystem as outlined in their EULA. This license does not override that agreement, but it does protect this work from unauthorized use by third parties outside of the TFP domain.

---

### ⚠️ EULA Scope Limitation Notice

In accordance with the 7 Days to Die End User License Agreement (EULA), I acknowledge that The Fun Pimps may use or adapt mod content—including metadata structure and documentation—created using their software and tools.

However, this license grant is **explicitly limited** to content used in connection with **7 Days to Die** and its directly associated services.

I do **not** grant The Fun Pimps—or any affiliated party—any rights to reuse, repurpose, or adapt this content in **any future games, platforms, or software titles**, including sequels, remakes, spin-offs, or other projects derived from the 7 Days to Die intellectual property, unless I have:

- Installed or used said software,
- Accepted a new EULA that grants additional rights, or
- Given **explicit written permission** for reuse.

All rights are otherwise reserved under applicable copyright law.
