### 0-SCore Documentation
---

The 0-SCore is a pivotal component that unlocks additional functionality in 7 Days to Die, enhancing the game's modding 
capabilities. 

By leveraging a combination of Harmony, SDX Patch Scripts, and custom scripts, this framework introduces new features 
and tools for both modders and players to utilize, significantly expanding the game's possibilities.

All these features are exposed to XML.

Note: Most of this documentation is AI Generated with tweaks and corrections manually.

## Index

# XPath
[XPath Explained with Examples](XPath/XPath.md)

[Conditionals](XPath/Conditionals.md)

[Includes](XPath/Includes.md)

----

# Examples
[Implementation Examples](Examples/ReadMe.md)


# Features
[Testing Features](Utils/Testing.md)

[Challenges](../Features/Challenges/ReadMe.md)

[FireV2](../Features/FireV2/Readme.md)

[Food Spoilage](../Features/FoodSpoilageV2/ReadMe.md)

[Material Modifier](../Features/MaterialModifier/ReadMe.md)

[Particles On Blocks](../Features/ParticlesOnBlocks/ReadMe.md)

[Advanced Recipes](../Features/Recipe/ReadMe.md)

[Remote Crafting](../Features/RemoteCrafting/ReadMe.md)

[Shared Reading](../Features/SharedReading/ReadMe.md)

[Trader](../Features/Trader/ReadMe.md)

[Version Check](../Features/VersionCheck/Readme.md)

[Weapon Camera Sway](../Features/WeaponCameraSway/ReadMe.md)

[Item Degradation](Examples/ItemDegradation.md)

[Workstation Degradation](Examples/WorkstationDegradation.md)

[Additional Recipe Output](Examples/AdditionalRecipeOutput.md)

# Patches
[Animation](../Harmony/Animation/ReadMe.md)

[Blocks](../Harmony/Blocks/ReadMe.md)

[Dialog](../Harmony/Dialog/ReadMe.md)

[EntityAlive](../Harmony/EntityAlive/ReadMe.md)

[Entity Move Helper](../Harmony/EntityMoveHelper/ReadMe.md)

[Item Actions](../Harmony/ItemActions/ReadMe.md)

[NPC Features](../Harmony/NPCFeatures/ReadMe.md)

[Player Features](../Harmony/PlayerFeatures/ReadMe.md)

[Sound Features](../Harmony/SoundFeatures/ReadMe.md)

[Prefab Features](../Harmony/PrefabFeatures/ReadMe.md)

[Progression](../Harmony/Progression/ReadMe.md)

[Tile Entities](../Harmony/TileEntities/ReadMe.md)

[Vehicles](../Harmony/Vehicles/ReadMe.md)

[Zombie Features](../Harmony/ZombieFeatures/ReadMe.md)

# Scripts
[Blocks](../Scripts/Blocks/Readme.md)

[Buffs](../Scripts/Buffs/ReadMe.md)

[Console Commands](../Scripts/ConsoleCmd/ReadMe.md)

[Dialogs](../Scripts/Dialogs/ReadMe.md)

[MinEvent](../Scripts/MinEvents/ReadMe.md)

[Quest Summary](../Scripts/Quests/ReadMe.md)

[Quest Examples](../Scripts/Quests/Examples.md)

## Utility AI  
Incomplete

[Utility AI - Overview](../Scripts/UtilityAI/Documentation/UtilityAI.md)

[Utility AI - Considerations](../Scripts/UtilityAI/Documentation/Considerations.md)

[Utility AI - Considerations Examples](../Scripts/UtilityAI/Documentation/ConsiderationExamples.md)

[Utility AI - Tasks](../Scripts/UtilityAI/Documentation/Tasks.md)

[Utility AI - Tasks Examples](../Scripts/UtilityAI/Documentation/TasksExamples.md)
